<?php
try {
    $db = new PDO("mysql:host=localhost;dbname=pdo_php", "root", "", array(PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8", PDO::MYSQL_ATTR_INIT_COMMAND => "SET CHARACTER SET utf8", array(PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION)));
} catch (PDOException $e) {
    print $e->getMessage(); // EĞER BAĞLANAMAZSA BAĞLANAMAMASINA SEBEB OLAN HATAYI DÖNER
}
//bağlantı cümlesini $db değişkenine attık.
//sql sorgularında $db değişkenini kullanacağız.
/*
  array(PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8", PDO::MYSQL_ATTR_INIT_COMMAND => "SET CHARACTER SET utf8", array(PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION))
  ## bu alan opsioneldir. Veritabanına bağlanma dil ayarlarınızı ve tablolara bağlanacak dil ayarlarımızı belirttik. Ayrıca hata durumunda hata moduna düşmesini belirttik.
  */
?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>PDO Php ile listeleme | Php Mutfağı</title>
    <!-- ekran küçüldükçe tarayıcının mobil kodları görmesi için -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- ekran küçüldükçe tarayıcının mobil kodları görmesi için -->
    <!-- bootstrap kütüphanesi style için -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <!-- bootstrap kütüphanesi style için -->
</head>

<body>
    <?php
    $uyeler = $db->query("SELECT * FROM uyeler", PDO::FETCH_ASSOC);
    //PDO::FETCH_ASSOC komutu tümünü dön demektir.
    //query listeleme ve tekli veri çekimlerinde kullanılır. PDO buradan anlıyor hangi tip sorgu çalıştıracağını
    //$db değişkenine bağlantı cümlemizi atadığımız için yazdık.
    // ### $db değişkenindeki bağlantı cümlesine git oradan query bul ve bu sorguyu query altında çalıştır.
    // ### dizi olarak düşünmeniz gerekiyor => $db["query"][$sorgunuz] gibi

    if ($uyeler->rowCount()) {
        //rowCount() komutu eğer bir pdo da değişkende satır sayısı varsa demektir.
        //Çünkü $uyeler değişkeni artık bir dizi
        // ## var_dump($uyeler); => bu komutu çalıştırırsanız daha iyi anlayacaksınız.
    ?>
        <a href="ekleme.php" class="btn btn-success btn-sm">+ YENİ KAYIT EKLE</a>
        
        <table class="table table-hover table-bordered table-striped" style="margin-top:15px">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Adı</th>
                    <th>Soyadı</th>
                    <th>Kullanıcı Adı</th>
                    <th>Şifre</th>
                    <th>Kayıt Tarihi</th>
                    <th>İŞLEMLER</th>
                </tr>
            </thead>
            <tbody>
                <?php
                foreach ($uyeler as $uye) {
                    //artık satır sayımız olduğuna göre foreach ile verileri yazdırabiliriz.
                    //dizi döndüğü için foreach, for gibi döngüler kullanılabilir.
                    //ama en mantıklısı foreach'tir. Eleman sayısını saymamıza gerek kalmadan otomatik eleman sayısı kadar döner.
                    ## var_dump($uye); => bu komutu çalıştırırsanız daha iyi anlayacaksınız.
                ?>
                    <tr>
                        <td><?php echo $uye["id"]; ?></td>
                        <td><?php echo $uye["uyeAdi"]; ?></td>
                        <td><?php echo $uye["uyeSoyadi"]; ?></td>
                        <td><?php echo $uye["kullaniciAdi"]; ?></td>
                        <td><?php echo $uye["sifre"]; ?></td>
                        <td><?php echo $uye["kayitTarihi"]; ?></td>
                        <td>
                            <a href="detay.php?id=<?php echo $uye["id"]; ?>" class="btn btn-info btn-sm">DETAY</a>
                            <!--
                                detay.php sayfasına gönderirken hangi üyenin bilgilerini çekeceğimizi bulmak için id bilgisinide gönderiyoruz. 
                                GET yöntemi ile id yi gönderiyoruz bu konuda daha fazla bilgiye sahip olmak için => https://phpmutfagi.com/subject/php-post-ve-get
                                ÖRN. ali diye seslendiğiniz birinin size bakması gibi düşünün burda id si ile seslenicez ve kayıt bize bakacak bilgilerini alacağız :)
                            -->
                            <a href="duzenle.php?id=<?php echo $uye["id"]; ?>" class="btn btn-warning btn-sm">DÜZENLE</a>
                            <!--
                                duzenle.php sayfasına gönderirken hangi üyenin bilgilerini güncelliceğimiz bulmak için id bilgisinide gönderiyoruz. 
                                GET yöntemi ile id yi gönderiyoruz bu konuda daha fazla bilgiye sahip olmak için => https://phpmutfagi.com/subject/php-post-ve-get
                                ÖRN. ali diye seslendiğiniz birinin size bakması gibi düşünün burda id si ile seslenicez ve kayıt bize bakacak bilgilerini alıp güncelleyeceğiz :)
                            -->
                            <a href="sil.php?id=<?php echo $uye["id"]; ?>" class="btn btn-danger btn-sm">SİL</a>
                            <!--
                                sil.php sayfasına gönderirken hangi üyenin bilgilerini sileceğimiz bulmak için id bilgisinide gönderiyoruz. 
                                GET yöntemi ile id yi gönderiyoruz bu konuda daha fazla bilgiye sahip olmak için => https://phpmutfagi.com/subject/php-post-ve-get
                                ÖRN. ali diye seslendiğiniz birinin size bakması gibi düşünün burda id si ile seslenicez ve kayıt bize bakacak bilgilerini alıp sileceğiz :)
                            -->

                            <!--
                            class dakiler bootstrap ın belirli button yapıları ve hazır kodlardır.
                            bootstrap ın classını yukarıda sayfamıza çağırdığımız için rahatlıkla kullanabiliyoruz.
                            Detaylar için; 
                            https://www.w3schools.com/bootstrap/bootstrap_buttons.asp
                            -->
                        </td>
                        <?php
                        /*
                        aslında $uye de bir dizi bize iç içe dizi dönüyor. Bu yüzden dizi yazdırır gibi yazdırıyoruz.
                        Key değerlerine; veritabanındaki sutun adını otomatik kendisi verir. bu yüzden ona göre çağırıyoruz.
                        ## var_dump($uye); => bu komutu çalıştırırsanız daha iyi anlayacaksınız.
                        */
                        ?>
                    </tr>
                <?php
                }
                ?>
            </tbody>
        </table>
    <?php } //satır kontrol if bitişi
    else
        echo 'KAYIT BULUNAMADI.';
    //eğer satır sayısı yoksa çalışacaktır.
    ?>
</body>

</html>