<?php
try {
    $db = new PDO("mysql:host=localhost;dbname=pdo_php", "root", "", array(PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8", PDO::MYSQL_ATTR_INIT_COMMAND => "SET CHARACTER SET utf8", array(PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION)));
} catch (PDOException $e) {
    print $e->getMessage(); // EĞER BAĞLANAMAZSA BAĞLANAMAMASINA SEBEB OLAN HATAYI DÖNER
}
//bağlantı cümlesini $db değişkenine attık.
//sql sorgularında $db değişkenini kullanacağız.
/*
  array(PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8", PDO::MYSQL_ATTR_INIT_COMMAND => "SET CHARACTER SET utf8", array(PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION))
  ## bu alan opsioneldir. Veritabanına bağlanma dil ayarlarınızı ve tablolara bağlanacak dil ayarlarımızı belirttik. Ayrıca hata durumunda hata moduna düşmesini belirttik.
  */

if ($_POST) {
    //Sayfa içerisinde bir POST olayı oluyorsa bu kodları çalıştırdık.
    //Kısaca formu post etmişse çalışacak kodlar.

    $hazirla = $db->prepare("INSERT INTO uyeler SET id = ?, uyeAdi = ?, uyeSoyadi = ?, kullaniciAdi = ?, sifre = ?, kayitTarihi = ?");
    $calisti = $hazirla->execute(array(null, $_POST["post_uyeAdi"], $_POST["post_uyeSoyadi"], $_POST["post_kullaniciAdi"], $_POST["post_sifre"], date("Y-m-d")));
    /*
    //prepare ekleme, güncelleme ve silme işlemlerinde kullanılır. PDO buradan anlıyor hangi tip sorgu çalıştıracağını
    //$db değişkenine bağlantı cümlemizi atadığımız için yazdık.
    //ilk sorguda sorgumuzu hazırladık.
    //ikincide execute komutu ile yukarıda yazdığımız sırayla sütunlara denk gelmesi gereken değişkenleri yazdık ve çalıştır dedik.
    //id kısmını null verdik çünkü tablo da otomatik artması gerektiğini ve benzersiz olması gerektiğini ayarladık.
    // ### dizi olarak düşünmeniz gerekiyor => $db["prepare"]["sql_cumlesi"], $db["hazirlanan_sql_cumlesi"]["execute"]["sorgunuz"]  gibi
    */

    //EĞER KAYIT İŞLEMİ GERÇEKLEŞTİYSE.
    if ($calisti) {
        //aşağıdaki kodumuz veri tabanına en son eklenen id bilgisini verir.
        $id = $db->lastInsertId();
        echo "YENİ EKLENEN ÜYE ID Sİ " . $id;
    } else echo "KAYIT BAŞARISIZ OLDU.";
}
?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>PDO Php ile veri ekleme | Php Mutfağı</title>
    <!-- ekran küçüldükçe tarayıcının mobil kodları görmesi için -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- ekran küçüldükçe tarayıcının mobil kodları görmesi için -->
    <!-- bootstrap kütüphanesi style için -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <!-- bootstrap kütüphanesi style için -->
</head>

<body>
    <form method="POST" action="ekleme.php">
    <!-- 
        POST yöntemi ile form daki bilgileri gönderiyoruz.
        bu konuda daha fazla bilgiye sahip olmak için => https://phpmutfagi.com/subject/php-post-ve-get
    -->
        <div class="col-md-4">
            <div class="form-group">
                <label>Üye Adı</label>
                <input type="text" class="form-control" name="post_uyeAdi" />
            </div>
            <div class="form-group">
                <label>Üye Soyadı</label>
                <input type="text" class="form-control" name="post_uyeSoyadi" />
            </div>
            <div class="form-group">
                <label>Üye Kullanıcı Adı</label>
                <input type="text" class="form-control" name="post_kullaniciAdi" />
            </div>
            <div class="form-group">
                <label>Üye Şifresi</label>
                <input type="password" class="form-control" name="post_sifre" />
            </div>
            <button type="submit" class="btn btn-primay">KAYDET</button>
        </div>
    </form>
</body>

</html>